<?php
// Direct API handler - bypasses .htaccess issues
require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/helpers.php';

handleCORS();

// Get the request path
$requestUri = $_SERVER['REQUEST_URI'];
$path = parse_url($requestUri, PHP_URL_PATH);

// Extract API path
if (strpos($path, '/production/api.php/') !== false) {
    $apiPath = substr($path, strpos($path, '/production/api.php/') + strlen('/production/api.php/'));
} elseif (strpos($path, '/api.php/') !== false) {
    $apiPath = substr($path, strpos($path, '/api.php/') + strlen('/api.php/'));
} else {
    $apiPath = $_GET['path'] ?? '';
}

if (empty($apiPath)) {
    jsonResponse(['error' => 'API path required', 'usage' => 'api.php/resource/action']);
}

$pathParts = explode('/', trim($apiPath, '/'));
$resource = $pathParts[0] ?? '';
$action = $pathParts[1] ?? null;
$id = $pathParts[2] ?? null;

if (empty($resource)) {
    jsonResponse(['error' => 'Resource required']);
}

// Load required files
try {
    require_once __DIR__ . '/includes/database.php';
    require_once __DIR__ . '/includes/jwt.php';
    require_once __DIR__ . '/includes/auth.php';
} catch (Throwable $e) {
    error_log("Database connection error: " . $e->getMessage());
    errorResponse('Database connection failed: ' . $e->getMessage(), 500);
}

// Set up $_GET parameters for the API files
if ($resource === 'auth' && $action) {
    $_GET['action'] = $action;
    if ($id) $_GET['id'] = $id;
} elseif ($resource === 'products') {
    if ($action === 'low-stock') {
        $_GET['low-stock'] = true;
    } elseif ($action === 'alerts' && $id === 'low-stock') {
        $_GET['alerts'] = 'low-stock';
    } elseif ($action === 'search' && $id) {
        $_GET['id'] = $id;
    } elseif ($action && !in_array($action, ['alerts', 'search'])) {
        $_GET['id'] = $action;
    }
} elseif ($resource === 'barcode') {
    if ($action === 'generate') {
        $_GET['generate'] = true;
    } elseif ($action === 'image' && $id) {
        $_GET['image'] = $id;
    } elseif ($action === 'label' && $id) {
        $_GET['label'] = $id;
    }
} else {
    if ($action !== null && !in_array($action, ['login', 'register', 'verify', 'profile', 'current', 'dashboard', 'summary', 'low-stock'])) {
        $_GET['id'] = $action;
    } elseif ($action !== null && in_array($action, ['current', 'dashboard', 'summary', 'low-stock'])) {
        $_GET[$action] = true;
    }
}

// Handle nested routes
if ($resource === 'sales' && $action === 'dashboard' && $id === 'summary') {
    $_GET['summary'] = 'dashboard';
}

if ($resource === 'reports' && $action) {
    $_GET['type'] = $action;
}

// Route to API file
$apiFile = __DIR__ . '/api/' . $resource . '.php';

if (file_exists($apiFile)) {
    require_once $apiFile;
} else {
    errorResponse('API endpoint not found: ' . $resource, 404);
}
?>