<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/database.php';
require_once __DIR__ . '/../includes/jwt.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';

handleCORS();

$method = $_SERVER['REQUEST_METHOD'];
$db = Database::getInstance();

// Check if this is a login or register request
$pathParts = explode('/', trim($_SERVER['REQUEST_URI'], '/'));
$actionFromPath = $pathParts[count($pathParts) - 1] ?? '';

$action = $_GET['action'] ?? $actionFromPath;

switch ($method) {
    case 'POST':
        if ($action === 'login') {
            $data = getRequestBody();
            validateRequired($data, ['username', 'password']);
            
            // Try with is_active first, fallback without it if column doesn't exist
            try {
                $user = $db->fetchOne(
                    'SELECT id, username, email, password, role, full_name, is_active FROM users WHERE username = ? AND (is_active = TRUE OR is_active IS NULL)',
                    [$data['username']]
                );
            } catch (Exception $e) {
                // Fallback if is_active column doesn't exist
                $user = $db->fetchOne(
                    'SELECT id, username, email, password, role, full_name FROM users WHERE username = ?',
                    [$data['username']]
                );
            }
            
            if (!$user || !password_verify($data['password'], $user['password'])) {
                errorResponse('Invalid credentials', 401);
            }
            
            unset($user['password']);
            
            $token = JWT::createToken([
                'userId' => $user['id'],
                'username' => $user['username'],
                'role' => $user['role']
            ], 86400); // 24 hours
            
            successResponse([
                'token' => $token,
                'user' => $user
            ], 'Login successful');
            
        } elseif ($action === 'register') {
            requireRole(['admin']);
            
            $data = getRequestBody();
            validateRequired($data, ['username', 'email', 'password', 'full_name']);
            
            $existing = $db->fetchOne('SELECT id FROM users WHERE username = ? OR email = ?', [$data['username'], $data['email']]);
            if ($existing) {
                errorResponse('Username or email already exists', 400);
            }
            
            $hashedPassword = password_hash($data['password'], PASSWORD_DEFAULT);
            $result = $db->execute(
                'INSERT INTO users (username, email, password, full_name, phone, role) VALUES (?, ?, ?, ?, ?, ?)',
                [$data['username'], $data['email'], $hashedPassword, $data['full_name'], $data['phone'] ?? null, $data['role'] ?? 'staff']
            );
            
            successResponse(['userId' => $result['lastInsertId']], 'User registered successfully', 201);
        }
        break;
        
    case 'GET':
        $user = requireAuth();
        
        if ($action === 'profile' || isset($_GET['profile'])) {
            $profile = $db->fetchOne(
                'SELECT id, username, email, role, full_name, phone, created_at FROM users WHERE id = ?',
                [$user['id']]
            );
            
            if (!$profile) {
                errorResponse('User not found', 404);
            }
            
            successResponse(['user' => $profile]);
        } elseif ($action === 'verify' || isset($_GET['verify'])) {
            successResponse(['valid' => true, 'user' => $user]);
        }
        break;
}

errorResponse('Invalid request', 400);
?>