<?php
function requireAuth() {
    $headers = getallheaders();
    $authHeader = $headers['Authorization'] ?? $headers['authorization'] ?? null;
    
    if (!$authHeader || !preg_match('/Bearer\s+(.*)$/i', $authHeader, $matches)) {
        errorResponse('Authorization token required', 401);
    }
    
    $token = $matches[1];
    $payload = JWT::validateToken($token);
    
    if (!$payload) {
        errorResponse('Invalid or expired token', 401);
    }
    
    return [
        'id' => $payload['userId'],
        'username' => $payload['username'],
        'role' => $payload['role']
    ];
}

function requireRole($allowedRoles, $user = null) {
    if (!$user) {
        $user = requireAuth();
    }
    
    if (!in_array($user['role'], $allowedRoles)) {
        errorResponse('Insufficient permissions', 403);
    }
    
    return $user;
}
?>