<?php
function handleCORS() {
    // Determine allowed origins from config
    $origin = $_SERVER['HTTP_ORIGIN'] ?? '';
    $allowed = defined('ALLOWED_ORIGINS') ? ALLOWED_ORIGINS : ['*'];

    if (in_array('*', $allowed)) {
        $allowOrigin = '*';
    } elseif ($origin && in_array($origin, $allowed)) {
        $allowOrigin = $origin;
    } else {
        $allowOrigin = null;
    }

    // Handle preflight requests
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        if ($allowOrigin) {
            header('Access-Control-Allow-Origin: ' . $allowOrigin);
            header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
            header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
            header('Access-Control-Max-Age: 86400');
            http_response_code(200);
            exit;
        }
        http_response_code(403);
        exit;
    }

    // Set CORS headers for normal requests only if origin is allowed
    if ($allowOrigin) {
        header('Access-Control-Allow-Origin: ' . $allowOrigin);
        header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
        header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
    }
}

function jsonResponse($data, $status = 200) {
    http_response_code($status);
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

function successResponse($data, $message = 'Success', $status = 200) {
    jsonResponse([
        'success' => true,
        'message' => $message,
        'data' => $data
    ], $status);
}

function errorResponse($message, $status = 400) {
    jsonResponse([
        'success' => false,
        'error' => $message
    ], $status);
}

function getRequestBody() {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        errorResponse('Invalid JSON in request body', 400);
    }
    
    return $data ?: [];
}

function validateRequired($data, $fields) {
    foreach ($fields as $field) {
        if (!isset($data[$field]) || empty($data[$field])) {
            errorResponse("Field '$field' is required", 400);
        }
    }
}
?>